#pragma once

#include <vcclr.h>
#include "IRImager.h"
#include "IRImagerClient.h"
#include "IRDeviceParams.h"
#include "IRDeviceDS.h"
#include "VideoCapture.h"
#include "IRCalibrationManager.h"
#include "IRLogger.h"

using namespace evo;
using namespace System;
using namespace System::IO;
using namespace System::Threading;
using namespace System::Runtime::InteropServices;

/**
* @class ThermalDevice
* @brief Client class instance for receiving data from an IR Imager device
* @author Heinrich Unbekannt (Optris GmbH), Stefan May (Evocortex GmbH)
*/
class ThermalDevice : IRImagerClient
{
public:
  /**
   * Constructor
   * @param[in] imagerFile XML configuration file
   */
  ThermalDevice(String ^imagerFile);

  /**
   * Destructor
   */
	~ThermalDevice();

  /**
   * Start streaming device
   * @return result of operation
   */
	bool start();

  /**
  * Stop streaming device
  * @return result of operation
  */
	bool stop();
  
  /**
   * Get image width
   * @return image width
   */
	unsigned int getWidth();

  /**
   * Get image height
   * @return image height
   */
	unsigned int getHeight();

  /**
   * Get device frequency
   * @return frequency in [Hz]
   */
	float getDeviceFrequency();	

  /**
   * Get number of frames already received
   * @return frame counter
   */
	unsigned int getFrameCount();

  /**
   * Get serial of attached device
   * @return serial number
   */
	unsigned long getSerial();   

  /**
   * Get pointer of frame buffer
   * @return buffer pointer
   */
	unsigned short* getDataBuffer();

  /**
   * Indicates if imager is ready for operation
   * @return operation state of device
   */
	bool isReadyToStart();

private:	

  /**
   * Callback method when thermal data is received. See documentation of IRImagerClient class
   */
	void onThermalFrame(unsigned short* data, unsigned int w, unsigned int h, IRFrameMetadata meta, void* arg);	

  /**
   * Callback method when raw data is received. See documentation of IRImagerClient class
   */
	void onRawFrame(unsigned char* data, int size);
	
	IRImager*             _imager;	
	IRDeviceParams        _irDeviceParams;
	IRDeviceDS*           _irDeviceDS;
	VideoCapture*         _videoCapture;
	
	bool                  _isReadyToStart;	

	unsigned short*       _dataBuffer;
	unsigned int          _frameCounter;
	
};